/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.integrator;

import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.integrator.IVWComponentConfiguration;
import filenet.vw.toolkit.admin.property.integrator.IVWAdaptorInfoListener;
import filenet.vw.toolkit.admin.property.integrator.IVWPanelInterface;
import filenet.vw.toolkit.admin.property.integrator.VWAdaptorInfo;
import filenet.vw.toolkit.admin.property.integrator.VWConfigurationModuleRegistrationPanel;
import filenet.vw.toolkit.admin.property.integrator.VWLibraryRegistrationPanel;
import filenet.vw.toolkit.admin.property.integrator.VWOperationTableModel;
import filenet.vw.toolkit.admin.property.integrator.VWParameterTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VWImportOperationPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
DocumentListener,
IVWToolbarBorderActionListener,
IVWPanelInterface,
IVWAdaptorInfoListener {
    private VWToolbarBorder m_operationsToolBar = null;
    private VWTable m_operationTable = null;
    private JTextArea m_descriptionTextArea = null;
    private VWToolbarBorder m_parametersToolBar = null;
    private VWTable m_parameterTable = null;
    private VWAdaptorInfo m_adaptorInfo = null;
    private Frame m_parentFrame = null;
    private VWOperationTableModel m_operationTableModel = null;
    private VWParameterTableModel m_parameterTableModel = null;
    private ClassLoader m_customClassLoader = null;

    public VWImportOperationPanel(Frame parentFrame, VWAdaptorInfo adaptorInfo, VWSystemConfiguration vwSystemConfiguration) {
        this.m_parentFrame = parentFrame;
        this.m_adaptorInfo = adaptorInfo;
        VWLibraryRegistrationPanel libPanel = new VWLibraryRegistrationPanel(this.m_parentFrame, vwSystemConfiguration);
        VWConfigurationModuleRegistrationPanel regPanel = new VWConfigurationModuleRegistrationPanel(this.m_parentFrame, vwSystemConfiguration, libPanel);
        this.m_customClassLoader = regPanel.getCustomClassLoader();
        this.createControls();
        this.updateTableSelection(this.m_operationTable, 0);
        this.m_adaptorInfo.addPropertyChangeListener(this);
    }

    public boolean isModified() {
        return this.m_operationTableModel.isModified() || this.m_parameterTableModel.isModified();
    }

    public void stopEditing() {
        if (this.m_operationTable != null) {
            this.m_operationTable.stopEditing();
        }
        if (this.m_parameterTable != null) {
            this.m_parameterTable.stopEditing();
        }
    }

    public void releaseResources() {
        if (this.m_operationsToolBar != null) {
            this.m_operationsToolBar.releaseReferences();
            this.m_operationsToolBar = null;
        }
        if (this.m_operationTable != null) {
            this.m_operationTable.removeAll();
            this.m_operationTable = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        if (this.m_parametersToolBar != null) {
            this.m_parametersToolBar.releaseReferences();
            this.m_parametersToolBar = null;
        }
        if (this.m_parameterTable != null) {
            this.m_parameterTable.removeAll();
            this.m_parameterTable = null;
        }
        if (this.m_adaptorInfo != null) {
            this.m_adaptorInfo.releaseResources();
            this.m_adaptorInfo = null;
        }
        if (this.m_operationTableModel != null) {
            this.m_operationTableModel.releaseResources();
            this.m_operationTableModel = null;
        }
        if (this.m_parameterTableModel != null) {
            this.m_parameterTableModel.releaseResources();
            this.m_parameterTableModel = null;
        }
        this.m_parentFrame = null;
        this.m_customClassLoader = null;
        this.removeAll();
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (event.getSource() == this.m_operationTable.getModel()) {
                    this.updateTableSelection(this.m_operationTable, nRow);
                    break;
                }
                if (event.getSource() != this.m_parameterTable.getModel()) break;
                this.updateTableSelection(this.m_parameterTable, nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (event.getSource() == this.m_operationTable.getSelectionModel()) {
                this.onSelectedOperation();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        try {
            if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
                this.onUpdateDescription();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeUpdate(DocumentEvent event) {
        try {
            if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
                this.onUpdateDescription();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.m_operationTable.stopEditing();
            this.m_parameterTable.stopEditing();
            if (event.getSource() == this.m_operationsToolBar) {
                switch (event.getID()) {
                    case 0x10000000: {
                        this.m_operationTableModel.deleteItem(this.m_operationTable.getSelectedRow());
                        break;
                    }
                    case 65536: {
                        this.performOperationImport();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void checkForErrors() throws Exception {
    }

    public String getInstructions() {
        return VWResource.ConfigureTheOperations;
    }

    public JComponent getInitialFocusComponent() {
        return this.m_operationTable;
    }

    public void adaptorInfoChanged() {
        if (this.m_adaptorInfo != null && this.m_operationTableModel != null) {
            this.m_operationTableModel.initialize(this.m_adaptorInfo.getQueueDefinition());
            this.updateTableSelection(this.m_operationTable, 0);
        }
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.2;
            gbCons.weighty = 0.75;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.createOperationsPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.weightx = 0.2;
            gbCons.weighty = 0.25;
            this.add((Component)this.createDescriptionPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.gridwidth = 2;
            JLabel label = new JLabel(VWResource.NoteSetComponentInfo);
            this.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.NoteSetComponentInfo, VWResource.NoteSetComponentInfo);
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.8;
            gbCons.weighty = 1.0;
            gbCons.gridheight = 2;
            gbCons.gridwidth = 1;
            this.add((Component)this.createParametersPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createOperationsPanel() {
        try {
            this.m_operationsToolBar = new VWToolbarBorder(VWResource.Operations, 0x10010000);
            this.m_operationsToolBar.addToolbarBorderActionNotifier(this);
            JPanel panel = this.m_operationsToolBar.getClientPanel();
            panel.setLayout(new BorderLayout());
            VWAccessibilityHelper.setAccessibility(this.m_operationsToolBar, this, VWResource.Operations, VWResource.Operations);
            this.m_operationTableModel = new VWOperationTableModel(this.m_parentFrame, this.m_adaptorInfo.getQueueDefinition());
            this.m_operationTableModel.addTableModelListener(this);
            this.m_operationTable = new VWTable(this.m_operationTableModel);
            this.m_operationTable.setRowSelectionAllowed(true);
            this.m_operationTable.getSelectionModel().addListSelectionListener(this);
            this.m_operationTable.getSelectionModel().setSelectionMode(0);
            this.m_operationTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_operationTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            panel.add((Component)new JScrollPane(this.m_operationTable), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_operationTable, this, VWResource.OperationsTable, VWResource.OperationsTable);
            return this.m_operationsToolBar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createDescriptionPanel() {
        try {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(new VWTitledBorder(VWResource.OperationDescription));
            VWAccessibilityHelper.setAccessibility(panel, this, VWResource.OperationDescription, VWResource.OperationDescription);
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(5);
            JTextArea.setDefaultLocale(Locale.getDefault());
            panel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextArea, this, VWResource.s_descriptionTextArea, VWResource.s_descriptionTextArea);
            panel.applyComponentOrientation(this.m_parentFrame.getComponentOrientation());
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createParametersPanel() {
        try {
            this.m_parametersToolBar = new VWToolbarBorder(VWResource.Parameters, 0);
            JPanel panel = this.m_parametersToolBar.getClientPanel();
            panel.setLayout(new BorderLayout());
            VWAccessibilityHelper.setAccessibility(this.m_parametersToolBar, this, VWResource.Parameters, VWResource.Parameters);
            this.m_parameterTableModel = new VWParameterTableModel(this.m_parentFrame);
            this.m_parameterTableModel.addTableModelListener(this);
            this.m_parameterTable = new VWTable(this.m_parameterTableModel);
            this.m_parameterTable.setRowSelectionAllowed(true);
            this.m_parameterTable.getSelectionModel().addListSelectionListener(this);
            this.m_parameterTable.getSelectionModel().setSelectionMode(0);
            this.m_parameterTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_parameterTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            panel.add((Component)new JScrollPane(this.m_parameterTable), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_parameterTable, this, VWResource.Parameters, VWResource.Parameters);
            return this.m_parametersToolBar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void updateTableSelection(JTable table, int nRow) {
        if (table == null) {
            return;
        }
        if (nRow == table.getSelectedRow()) {
            table.clearSelection();
        }
        if (nRow <= table.getRowCount() - 1) {
            table.setRowSelectionInterval(nRow, nRow);
        } else if (table.equals(this.m_operationTable)) {
            this.m_operationsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_operationsToolBar.getClientPanel(), 2, 0x10000000));
        }
    }

    private void onSelectedOperation() {
        try {
            int nRowIndex = this.m_operationTable.getSelectedRow();
            String name = (String)this.m_operationTableModel.getValueAt(nRowIndex, 0);
            if (name == null || name.length() == 0) {
                int nButtons = 0x10000000;
                this.m_operationsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_operationsToolBar.getClientPanel(), 2, nButtons));
            } else {
                int nButtons = 0x10010000;
                this.m_operationsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_operationsToolBar.getClientPanel(), 1, nButtons));
            }
            this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
            this.m_descriptionTextArea.setText((String)this.m_operationTableModel.getValueAt(nRowIndex, 1));
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            JTextArea.setDefaultLocale(Locale.getDefault());
            this.m_parameterTable.stopEditing();
            this.m_parameterTableModel.refresh(this.m_operationTableModel.getRowItemAt(nRowIndex));
            this.updateTableSelection(this.m_parameterTable, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateDescription() {
        try {
            if (this.m_operationTableModel != null && this.m_operationTable != null) {
                int nRowIndex = this.m_operationTable.getSelectedRow();
                String currentDesc = this.m_descriptionTextArea.getText();
                this.m_operationTableModel.setValueAt(currentDesc, nRowIndex, 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performOperationImport() {
        try {
            IVWComponentConfiguration configurationModule = this.m_adaptorInfo.getComponentConfigurationClass();
            if (configurationModule != null) {
                String[] operationDescriptors = configurationModule.getOperationDescriptors(this.m_parentFrame, this.m_adaptorInfo.getComponentDescriptorString(), this.m_customClassLoader);
                if (operationDescriptors != null && operationDescriptors.length > 0) {
                    for (int i = 0; i < operationDescriptors.length; ++i) {
                        this.m_operationTableModel.addItem(operationDescriptors[i]);
                    }
                }
            } else {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.CannotRetrieveOperations, VWResource.ErrorMessage, 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
    }
}

